let read filename = 
  (* On ouvre le fichier en mode binaire *)
  let ic = open_in_bin filename in
  (* On dtermine sa longueur *)
  let length = in_channel_length ic in
  (* On lit une chane de la longueur correspondante *)
  really_input_string ic length;;

let to_array s =
  Array.init (String.length s) (fun i -> int_of_char s.[i]);;

let to_string t =
  String.init (Array.length t) (fun i -> char_of_int t.(i));;


let tri_rotations t = (* definir compare_rotations avant *)
  let n = Array.length t in
  let ordre = Array.make n 0 in
  for i = 1 to n-1 do ordre.(i) <- i done;
  Array.sort (compare_rotations t) ordre;
  ordre;;
