#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <assert.h>
#include <string.h>

//----------------------------------------------------------------
// Structures de données manipulées

// Structure pour les blocs d'allocation mémoire

struct block {
    int* p_start;         // L'adresse du premier de [size] entiers consécutifs
    int size;             //
    struct block* p_next; // L'adresse du prochain bloc dans la liste (ou NULL)
};

// Structure pour gérer l'allocation
// soit deux listes chaînées, une pour les blocs disponibles,
// une pour les blocs présentement utilisés

struct pool {
    struct block* p_avail;  // Une liste chaînée de blocs disponibles
    struct block* p_used;   // Une liste chaînée de blocs présentement alloués
};


//----------------------------------------------------------------
// Création d'une structure pour gerer une zone de mémoire

struct pool new_pool(int size) {
    // Création d'une structure avec deux listes vides
    struct pool pool = { .p_avail = NULL, .p_used = NULL };

    // Allocation d'une zone mémoire
    int* p_memory = malloc(size*sizeof(int));

    // Si l'allocation s'est bien passée
    if (p_memory != NULL) {
        // On crée un seul bloc de mémoire disponible
        pool.p_avail = malloc(sizeof(struct block));

        // Son adresse de début est celle obtenue avec malloc
        (*pool.p_avail).p_start = p_memory;

        // Sa taille est la taille totale allouée
        (*pool.p_avail).size = size;

        // Pas d'autre bloc dans la liste
        (*pool.p_avail).p_next = NULL;
    }

    // On retourne la structure créée
    // (elle peut ne contenir aucune mémoire si l'appel à malloc a échoué)
    return pool;
}


//----------------------------------------------------------------
// Recherche d'un bloc adéquat dans une liste
//
// Les fonctions suivantes prennent une liste de blocs
// (= l'adresse du premier bloc de la liste chaînée)
// et une taille souhaitée
//
// Elles retournent l'adresse d'un bloc de taille
// supérieure ou égal à la taille requise s'il en existe
// et NULL sinon
//
// AUCUNE MODIFICATION N'EST FAITE SUR LA LISTE


// Stratégie (1) : premier bloc de taille suffisante

struct block* get_first(struct block* p_lst, int size) {
    // A COMPLETER !
    return NULL;
}

// Stratégie (2) : plus grand bloc de taille suffisante

struct block* get_largest(struct block* p_lst, int size) {
    // A COMPLETER !
    return NULL;
}

// Stratégie (3) : plus petit bloc de taille suffisante

struct block* get_smallest(struct block* p_lst, int size) {
    // A COMPLETER !
    return NULL;
}


//----------------------------------------------------------------
// Recherche d'un bloc dans une liste correspondant à une adresse
//
// La fonction get_from_ptr prend en argument une liste chaînée
// de blocs (alloués) et un pointeur (int*) retournée lors
// d'un appel à ialloc, et retourne un pointeur vers le bloc
// dont l'adresse correspond au pointeur en question
//
// Cette recherche ne devrait jamais échouer !

struct block* get_from_ptr(struct block* p_lst, int* ptr) {
    // A COMPLETER !
    return NULL;
}


//----------------------------------------------------------------
// La fonction remove_block_from_list prend en argument
// un pointeur vers une variable contenant une liste de blocs
// (donc un pointeur vers un pointeur vers un bloc)
// et retire ce bloc de la liste en préservant la liste chaînée

void remove_block_from_list(struct block** pp_lst, struct block* p_block) {
    assert(*pp_lst != NULL);
    // A COMPLETER !
}


//----------------------------------------------------------------
// La fonction add_block_to_list prend en argument
// un pointeur vers une variable contenant une liste de blocs
// (donc un pointeur vers un pointeur vers un bloc)
// et ajoute ce bloc en tête de la liste en préservant la
// structure de la liste chaînée

void add_block_to_list(struct block** pp_lst, struct block* p_block) {
    assert(pp_lst != NULL);
    // A COMPLETER !
}


//----------------------------------------------------------------
// La fonction insert_block_into_list prend en argument
// un pointeur vers une variable contenant une liste de blocs
// (donc un pointeur vers un pointeur vers un bloc)
// dont les adresses (champs start) sont rangées par ordre
// croissant et ajoute ce bloc en tête de la liste en préservant
// la structure de la liste chaînée et la condition sur l'ordre

void insert_block_into_list(struct block** pp_lst, struct block* p_block) {
    assert(pp_lst != NULL);
    // A COMPLETER !
}


//----------------------------------------------------------------
// La fonction insert_block_into_list prend en argument
// deux pointeurs vers deux blocs et retourne un booléen
// indiquant si la fin du premier bloc coïncide avec le
// début du second dans la mémoire

bool consecutive(struct block* p_block1, struct block* p_block2) {
    // A MODIFIER
    return false;
}


//----------------------------------------------------------------
// La fonction clean_list prend en argument une liste
// chaînée de blocs dont les adresses (champ start)
// sont rangées par ordre croissant, et fusionne tant
// que c'est possible les blocs consécutifs en mémoire

void clean_list(struct block* p_lst) {
    if ((p_lst == NULL) || ((*p_lst).p_next == NULL)) return;

    struct block* p_next = (*p_lst).p_next;

    if (consecutive(p_lst, p_next)) {
        // A COMPLETER !
    } else {
        // A COMPLETER !
    }
}


//----------------------------------------------------------------
// La fonction ialloc prend en argument un pointeur vers une
// structure de gestion de l'allocation mémoire et une taille
// requise
//
// Elle retourne un pointeur int* en cas de succès
// et NULL si l'allocation est impossible

int* ialloc(struct pool* p_pool, int size) {
    assert(size>0);

    // Choix de la stratégie
    typedef enum { ST_FIRST, ST_LARGEST, ST_SMALLEST } strategy_type;
    strategy_type strategy = ST_FIRST;

    // On cherche un bloc suffisamment grand disponible
    struct block* p_block = NULL;
    if (strategy == ST_FIRST) { p_block = get_first((*p_pool).p_avail, size); }
    else if (strategy == ST_LARGEST) { p_block = get_largest((*p_pool).p_avail, size); }
    else if (strategy == ST_SMALLEST) { p_block = get_smallest((*p_pool).p_avail, size); }

    // S'il n'y en a pas, l'allocation ne peut aboutir
    if (p_block == NULL) {
        return NULL;
    }

    // A COMPLETER !
    return NULL;
}


//----------------------------------------------------------------
// La fonction ifree prend en argument un pointeur vers une
// structure de gestion de l'allocation mémoire et une
// adresse (int*) précédemment retournée par ialloc
//
// Elle rend disponible le bloc en question
//
// Pour des raisons de simplicité, si l'adresse fournie est NULL,
// la fonction ne fait rien (on peut ainsi appeler la fonction
// sur l'adresse retournée par ialloc même si elle a échoué)

void ifree(struct pool* p_pool, int* ptr) {
    if (ptr==NULL) return; // On ne fait rien si le pointeur est NULL

    // A COMPLETER !
}


//----------------------------------------------------------------
// La fonction print_bloc_list prend en argument une liste
// de blocs et un nombre maximal de blocs à afficher,
// et affiche dans la sortie standard les blocs contenus dans
// la liste, en s'arrêtant en cas de cycle ou lorsque le nombre
// maximum de blocs est atteint

void print_block_list(struct block* p_lst, int max_blocks) {
    struct block** pp_seen = malloc(max_blocks * sizeof(struct block*));
    for (int i=0; i<max_blocks; ++i, p_lst=(*p_lst).p_next) {
        if (p_lst==NULL) {
            printf("<end of list>\n"); fflush(stdout); return;
        }
        for (int j=0; j<i; ++j) {
            if (p_lst == pp_seen[j]) {
                printf("<cycle!>\n"); fflush(stdout); return;
            }
        }
        pp_seen[i] = p_lst;
        printf("[%d] At %p, size %5d      [Struct block at %p, next at %p]\n",
               i, (void*)(*p_lst).p_start, (*p_lst).size, (void*)p_lst, (void*)(*p_lst).p_next);
        fflush(stdout);
    }
    printf("<...>\n"); fflush(stdout);
}

void print_pool(struct pool* p_pool) {
    printf("\nMemory state:\n\n");
    printf("List of available blocks:       [First struct block at %p]\n", (void*)(*p_pool).p_avail);
    fflush(stdout);
    print_block_list((*p_pool).p_avail, 64);
    printf("\n");
    fflush(stdout);
    printf("List of allocated blocks:       [First struct block at %p]\n", (void*)(*p_pool).p_used);
    fflush(stdout);
    print_block_list((*p_pool).p_used, 64);
    printf("\n");
    fflush(stdout);
}

//----------------------------------------------------------------
// La fonction test prend en argument un pointeur vers
// une structure de gestion de la mémoire, une séquence
// d'opérations et sa taille, et effectue une série de tests
// en affichant les résultats

void test(struct pool* p_pool, int seq[], int n, int debug) {
    // On réserve un tableau de pointeurs pour mémoriser les allocations
    // qui ont été faites, afin de pouvoir les libérer plus tard
    int* ptr[100] = { NULL };

    char* sres[] = { "FAILURE", "SUCCESS" };

    // On parcourt la séquence d'allocations / libérations
    for (int i=0; i<n; i+=2) {
        int var = seq[i];       // La "variable" qui recevra l'allocation
        int sze = seq[i+1];     // La taille demandée (0 = libération)

        assert((var>=0)&&(var<100)&&(sze>=0));

        if (debug) {
            print_pool(p_pool);
            printf("\033[30;101m");
        }

        if (sze>0) {
            // Allocation de mémoire via ialloc
            assert(ptr[var] == NULL);
            printf("Allocating (%02d)  size = %4d", var, sze);
            if (debug) { printf("\033[37;40m"); }
            fflush(stdout);
            ptr[var] = ialloc(p_pool, sze);
            printf("  <%s, addr = %p>", sres[ptr[var]!=NULL], (void*)ptr[var]);
        } else {
            // Libération de mémoire via ifree
            printf("Deallocating (%02d, addr = %p)", var, (void*)ptr[var]);
            if (debug) { printf("\033[37;40m"); }
            fflush(stdout);
            if (ptr[var] != NULL) {
                ifree(p_pool, ptr[var]);
                ptr[var] = NULL;
                printf("  <done>");
            } else {
                printf("  <skipped, not allocated>");
            }
        }
        printf("\n");
        fflush(stdout);
    }
}

//----------------------------------------------------------------
// Quelques séquences de tests (vous pouvez créer les vôtres)

// Première séquence pour vérifier le bon fonctionnement

int seq1[] = { 0, 1536,  // Doit échouer si la ressource totale est 1024
               1, 256,
               2, 512,
               3, 128,
               4, 512,   // Doit échouer si la ressource totale est 1024
               5, 64,
               6, 64,
               7, 64 };  // Doit échouer si la ressource totale est 1024

// Seconde séquence pour tester les stratégies d'allocation

int seq2[] = { 0, 256,   // On alloue 256, 512, 128 puis 64
               1, 512,
               2, 128,
               3, 64,
               3, 0,     // On libère tout
               2, 0,
               1, 0,
               0, 0,
               0, 64,    // On alloue 64, 128, 256 puis 512
               1, 128,
               2, 256,
               3, 512,   // Peut échouer selon la stratégie
               0, 0,     // On libère tout
               1, 0,
               2, 0,
               3, 0,
               0, 512,
               1, 394 }; // Va échouer s'il n'y a pas de consolidation


//----------------------------------------------------------------
// Programme principal

int main(int argc, char* argv[]) {
    // On réserve une zone de mémoire pour les allocation
    struct pool pool = new_pool(1024);

    // Activation du mode debug avec l'option en ligne de commande --debug
    bool debug = false;
    if (argc>1) {
        if ((argc>2) || (strcmp(argv[1], "--debug"))) {
            fprintf(stderr, "Usage : %s [--debug]\n", argv[0]);
        } else {
            debug=true;
        }
    }

    // Choix du protocole de test (décommenter une seule ligne)
    test(&pool, seq1, sizeof(seq1)/sizeof(int), debug);       // Séquence 1
    // test(&pool, seq2, sizeof(seq2)/sizeof(int), debug);       // Séquence 2

    // Affichage de l'état de la mémoire à l'issue du programme
    print_pool(&pool);

    return 0;
}
